﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IndianHealthService.BMXNet
{
    /// <summary>
    /// This interface is used on  UserControl-based components which are designed to work both inside
    /// the EHR and inside a WinForm application.  "Consumer" interfaces basically tell Frameworks
    /// that a "Consumer"-implementating object need a specific service, versus the service being queried.
    /// </summary>
    /// <remarks>
    /// If your component doesn't implement LocalConsumer you can still have a user-control.  However, implementing
    /// LocalConsumer is very common because of exclusive access to the patient/visit Context.
    /// </remarks>
    public interface LocalConsumer
    {
        /// <summary>
        /// This property is set with a LocalSession by the framework.  The receiver uses it for Context,
        /// local Events, and other services.
        /// </summary>
        LocalSession LocalSession { set; }
    }
}
